# Vytvoření a zveřejnění dražby skrz portaldrazeb.cz API

tento příklad obsahuje:
1. autentizaci
2. vypsání dostupných kategorií
3. založení/vytvoření dražby
4. editaci stávající dražby
5. přiložení obrázků k dražbě
6. přiložení dokumentů k dražbě
7. zveřejnění dražby

- referenční aplikací pro přístup k API je [Postman/7.28.0](https://www.postman.com/), příložené příklady requestů používají několik variables: 
    - `username`
    - `password`
    - `token`
    - `auction`
    - `office`
    - `person`
    - `category`
    - `number`
    - `img-1-id`
    - `img-1-hash`
    - `img-2-id`
    - `img-2-hash`
    - `doc-1-id`
    - `doc-1-hash`
    - `doc-2-id`
    - `doc-2-hash`
- příklady volání jsou pro [curl](https://curl.haxx.se/) 
- potřebné podklady:
    - popis dražby
    - 2 jpg obrázky
    - 2 pdf dokumenty
    - id kategorie
    - hash kanceláře dražebníka
    - hash zodpovědné osoby/uživatele

## Autentizace

`POST https://www.portaldrazeb.cz/login/jwt`

do request body vložíme přihlašovací údaje

```sh
curl --location --request POST 'https://www.portaldrazeb.cz/login/jwt' \
--header 'Content-Type: application/json;charset=utf-8' \
--data-raw '{ "username": "executor@test.arodax.com", "password": "123456" }'
```

> Postman: přihlašovací údaje uložíme do variables `username` a `password`

vrátí response

```json
{
    "token": "eyJ0eXAiOiJKV1QiLCJhbGciOiJSUzI1NiJ9.eyJpYXQiOjE1OTUyNTQwODMsImV4cCI6MTU5NTI1NzY4Mywicm9sZXMiOlsiUk9MRV9BVUNUSU9ORUVSX0VYRUNVVE9SIiwiUk9MRV9SRVNQT05TSUJMRV9QRVJTT04iLCJST0xFX09GRklDRV9BRE1JTiJdLCJlbWFpbCI6ImV4ZWN1dG9yQHRlc3QuYXJvZGF4LmNvbSJ9.HtR93nnRo5mQYi-Vys4schFoe99zcj2ZorolwxncptZxPgidGioYZq5aozEPgEsKC6zC_JE5t7Ly8VDSVwWdqRuIgyECgNzBTZNGNB6Q02LmPRH5NtoNyit4wQTNSUJLzqOuppO1UU1oudmpn8m7GiDifYfQLNxqIhCMwUHnife_TpPWDgIZvS2fV9TP3rHCBesPVutMjWKVzuHRX6QYpt0Enp1qFnSujyfbFOYT9uo_d9NwE7pQv9OavoUTBTN3rRLeK-7-bkA_mkBNKI4c9ZRdJLbBcq-8W8oxmbidIN6pWbcO3-btQx_xuQ4A2HUEyW4P27uderyh_PlVcBZ35nffxGfHiXdG3vIEQj6LRRUk2kpq9hLIHyYzPtZ0jigEU1Je_s9rAUybbae_0TB25U2KsPDOG7iGepmdCKuYD24pEPmMpVP4_V4THFw1u0fvSpGMBlNmdc0STd77GraLInbgFHy3DFiWTLIGBGYkEXxZ5q_rimHM_UYbDu_frCtUSU8xG7LP8rmGgY9IiOHUyNar3JItUfVEMUIwVYHSHbIVDjj2XclE1ToydSqP_QqrDsSvVjuH0_Ura9cktPQIShO5J86TmWbsNLCUYa6b8Ov-VvnUGty-Uex17hzVTfA04AaejR5Ccte6B3z8iA6qw7Kcgj0deD3I1-uoVgf9Vcs"
}
```

hodnotu pole `token` následně vkládáme do všech requestů na všechny ostatní endpointy, jako header `Authorization Bearer`, tedy například

```sh
curl --header 'Authorization: Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJSUzI1NiJ9.eyJpYXQiOjE1OTUyNTQwODMsImV4cCI6MTU5NTI1NzY4Mywicm9sZXMiOlsiUk9MRV9BVUNUSU9ORUVSX0VYRUNVVE9SIiwiUk9MRV9SRVNQT05TSUJMRV9QRVJTT04iLCJST0xFX09GRklDRV9BRE1JTiJdLCJlbWFpbCI6ImV4ZWN1dG9yQHRlc3QuYXJvZGF4LmNvbSJ9.HtR93nnRo5mQYi-Vys4schFoe99zcj2ZorolwxncptZxPgidGioYZq5aozEPgEsKC6zC_JE5t7Ly8VDSVwWdqRuIgyECgNzBTZNGNB6Q02LmPRH5NtoNyit4wQTNSUJLzqOuppO1UU1oudmpn8m7GiDifYfQLNxqIhCMwUHnife_TpPWDgIZvS2fV9TP3rHCBesPVutMjWKVzuHRX6QYpt0Enp1qFnSujyfbFOYT9uo_d9NwE7pQv9OavoUTBTN3rRLeK-7-bkA_mkBNKI4c9ZRdJLbBcq-8W8oxmbidIN6pWbcO3-btQx_xuQ4A2HUEyW4P27uderyh_PlVcBZ35nffxGfHiXdG3vIEQj6LRRUk2kpq9hLIHyYzPtZ0jigEU1Je_s9rAUybbae_0TB25U2KsPDOG7iGepmdCKuYD24pEPmMpVP4_V4THFw1u0fvSpGMBlNmdc0STd77GraLInbgFHy3DFiWTLIGBGYkEXxZ5q_rimHM_UYbDu_frCtUSU8xG7LP8rmGgY9IiOHUyNar3JItUfVEMUIwVYHSHbIVDjj2XclE1ToydSqP_QqrDsSvVjuH0_Ura9cktPQIShO5J86TmWbsNLCUYa6b8Ov-VvnUGty-Uex17hzVTfA04AaejR5Ccte6B3z8iA6qw7Kcgj0deD3I1-uoVgf9Vcs'
```

token má platnost 20 minut, tedy pokud endpoint vrátí status 403/401, je potřeba token obnovit.

> Postman: token uložíme do variable `token`

## Výpis dostupných kategorií

`GET https://www.portaldrazeb.cz/admin/categories.json`

```sh
curl --location --request GET 'https://www.portaldrazeb.cz/admin/categories.json' \
--header 'Authorization: Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJSUzI1NiJ9.eyJpYXQiOjE1OTUzNDY3NzAsImV4cCI6MTU5NTM1MDM3MCwicm9sZXMiOlsiUk9MRV9BVUNUSU9ORUVSX0VYRUNVVE9SIiwiUk9MRV9SRVNQT05TSUJMRV9QRVJTT04iLCJST0xFX09GRklDRV9BRE1JTiJdLCJlbWFpbCI6ImV4ZWN1dG9yQHRlc3QuYXJvZGF4LmNvbSJ9.bIPp7BzTSUg0ebkSi_Zsiff7KW4IR6s5ydV9xCA4bpE3xmG588l1_2iVKFMkjJPwF5qRhNkH5t5LYnRfXQA6wv75nijCLK0rwc6ZgiTYDSDYi6IofUiTetDFaiXxndVgh6TDdhLXLOTY-FwOXLzp4IC0_F6UjqhAzD0v-pk7TbNd-W6SYrbTUqonCv89aTcoU6UstgEPFX_ri02YjTzQ33-f6LF5wMN_pO3lDmZTqwas6nXt7GTRCw2VO-oZgeC3aPdS2j_1ddKbUY5OpdETd5Q4uNHzI3Tk5-A9-zbh2U7iSeCIRqSiEu1Q2xMGz3NZ33DEBvAMXDLJ5LUIOSu7T-JiqNcOHcEw5srpUwi5Gt6NfmuK4tpLX3MkIFizlwotFqGh1l0_hHE2PAyBrAJFpMKCXYcM_DFWgehy9nN0OU-uSOaGgwldR4xvSJWjzlLiVYBC7YDJi6V8irjgYgjqUmEupv_qH2HHIVvpKXCUacLA-_K4CKwAVZ_R_4-AwEBuNEXVTwlQEky5p8d8rI7vz5RZHe-U7pS3vY-fV6LgrCeQBxu_j1X4sa0sFSnZsphK8CNoZ35ZNH9h0A9Ui33EiGYVzDLYF19c4A3ykZc9uvcEH7iboJV6n8ImgJ316Wjab4FzETQsydmmH2HLawi8hKHf4Zza0k-2Dk9rpoa2v5s'
```

vráti odpověď **200** a v response body výpis kategorií. zvolíme si kategorii `/Nemovitosti/Rekreační objekt` a zapíšeme si její `id`.

> Postman: id uložíme do variable `category`


### Dražebník a zodpovědná osoba

hash kanceláře dražebníka a zodpovědné osoby zjistíme buď po přihlášení účtem správce kanceláře v administraci portaldrazeb.cz

- Menu -> Kancelář -> Editace -> Hash
- Menu -> Kancelář -> Členové -> Upravit -> Editace -> Hash

nebo zavoláním 

`GET https://www.portaldrazeb.cz/admin/office/my.json`

```sh
curl --location --request GET 'https://www.portaldrazeb.cz/admin/offices/my.json' \
--header 'Authorization: Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJSUzI1NiJ9.eyJpYXQiOjE1OTU5NTAyMzgsImV4cCI6MTU5NTk1MzgzOCwicm9sZXMiOlsiUk9MRV9BVUNUSU9ORUVSX0VYRUNVVE9SIiwiUk9MRV9SRVNQT05TSUJMRV9QRVJTT04iLCJST0xFX09GRklDRV9BRE1JTiJdLCJlbWFpbCI6ImV4ZWN1dG9yQHRlc3QuYXJvZGF4LmNvbSJ9.j2yR7qoBYjowWS7RDRCpKPrBWiDlii7NSe1OXnGEambbUdCWrvzMf6PzSkEXowqXK-uE0XKOSvkpKREceWzu2DAH1IOY62izUpQ7ABink4JI6Rrvv1NzJd6zWPyoMyQd7T5bnnRonDBG6iIKvLZFymadXbxFFKgLCM1sBg1qVf_RUAZCPf4mb4XXy19IiseebYOT7BXkzowXXm8o8QJXtgB8_Kg9tpCmagZpMCGkoIbjMNNGcNUdZU1A4FmSReQT72BlzuEaeY8nUYPbCbvfNFaoXEF57Ar5QbouwyqhqltvNc5r05fRvAAkoMZeVHcoXJZ5Patv-Svdn17k7y7BX0Q9r0i_QaUu0V-i-9uxzFwc_nbntIan2UHFw61pVLXew57ZAIG5g3nptfzvOTpjqRzYeHKqKVnkmTMcgPcFfZOuDjh-hxmtl57ilqSEI1F50EHTCg4grOvbxyrhkICx39RhBRyFl-aAP_WLee0yOI1F1eyaq3PRWEblaTm304jQJW4nHiEZw9o2YaT0cinq702Ew0F4RmNUglwS6H_vOTovrY3f56-9oS38bnTZwteLChab_pShxQcrrLOEvLnVIbFDx_pQuNd8mYJaiHloiWcnbELYw0ZMdnWjFCng-orI81JEcJHe8MM_8gO5aCTAaemhfSQLHGbmwHtYzoawm8I'
```

vrátí odpověď **200** a v response body identifikátor kanceláře a zodpovědných osob

```json
{
    "auctioneer_office": {
        "hash": "dGO",
        "title": "Testovaci Exekutorský Úřad",
        "email": "exekutorsky-urad@test.arodax.com"
    },
    "responsible_persons": [
        {
            "hash": "Oz",
            "name": "Testovací  Exekutor",
            "email": "executor@test.arodax.com"
        },
        {
            "hash": "zkP",
            "name": "Testovací  Test",
            "email": "info@arodax.com"
        }
    ]
}
```

> Postman: hash kanceláře uložíme do variable `office`
> Postman: hash zodpovědné osoby uložíme do variable `person`
> Postman: číslo dražby uložíme do variable `number`

## Vytvoření dražby

vytvoříme exekuční dražbu s nemovitým předmětem dražby

`POST https://www.portaldrazeb.cz/admin/auctions/new/execution/real.json`

do request body vložíme minimálně všechny povinné položky. 

```json
{"auction":{"documents":[],"images":[],"item":{"title":"Karlštejn","category":5,"description":"<p>Karlštejn (německy Karlstein [ˈkɑːʁlštain]) je původem středověký královský hrad, nacházející se na katastrálním území Budňany ve stejnojmenné městysi Karlštejn v&nbsp; okrese Beroun asi třináct kilometrů východně od Berouna a třicet kilometrů jihozápadně od centra Prahy. Leží rovněž uprostřed chráněné krajinné oblasti Český kras. Hrad jakožto státní instituce je ve vlastnictví České republiky a jeho správu zajišťuje Národní památkový ústav. Veřejnosti je hrad Karlštejn přístupný nepřetržitě od roku 1905,[1] a patří tak k&nbsp;jedněm z&nbsp;nejdéle zpřístupněných památek na území Česka.[2] Od 30.&nbsp;března 1962 je veden jako národní kulturní památka,[3] jejíž každoroční návštěvnost od počátku šedesátých let neklesá pod hranici 200 tisíc návštěvníků ročně.[4] Karlštejn tak dlouhodobě patří mezi desítku nejnavštěvovanějších památek České republiky – je hned druhým nejvíce vyhledávaným hradem Česka,[5] a&nbsp;v&nbsp;rámci památek spravovaných Národním památkovým ústavem si dlouhodobě drží pozici čtvrté nejnavštěvovanější památky.</p>","tags":[],"location_county_name":null,"location_coords":null,"ruian":20704429,"display_easements":"no","cadastral_office":"Karlovy Vary","easements":"Věcná břemena, výměnky a nájemní, pachtovní či předkupní práva, která prodejem nemovité věci v dražbě nezaniknou, nebyla zjištěna (§ 336a odst. 1 písm. d) o.s.ř.)."},"number":"999EX6789/20","voluntary":false,"online":false,"electronic":true,"auctioneer_office":"dGO","status":"draft","responsible_person":"Oz","start_at":"2021-02-07T12:00:00.000Z","original_end_at":"2021-02-14T12:00:00.000Z","estimated_price":99000000,"item_price":1000000,"minimal_bid":0,"caution_deposit":0,"caution_account_number":null,"caution_variable_symbol":null,"account_specific_symbol":"RČ nebo IČ","display_visits":"no","display_creditors":"no","display_preemption_right":"no","display_co_owner_right":"no","decision_during":"","location_county_name":null,"location_coords":null,"disabled_at":null,"ruian":null,"display_buyback_reservation":"no","display_accusation_of_exclusion":"no","eligible":"","obligatory":"","objection":false,"overbid":false,"overbid_end_at":null,"payment_by_credit":false,"type":"execution","recommendation":true,"visits":"Prohlídky nejsou organizovány.","creditors":"Do dražby nepřihlásil svou pohledávku žádný věřitel.","preemption_right":"Nebylo prokázáno.","co_owner_right":"Nebylo prokázáno.","buyback_reservation":"Nebyla prokázána.","accusation_of_exclusion":"Do zahájení dražby nebylo zjištěno, že by byla podána žaloba na vyloučení prodávaného předmětu dražby z exekuce."}}
```

```sh
curl --location --request POST 'https://www.portaldrazeb.cz/admin/auctions/new/execution/real.json' \
--header 'Content-Type: application/json;charset=utf-8' \
--header 'Authorization: Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJSUzI1NiJ9.eyJpYXQiOjE1OTUzNDY3NzAsImV4cCI6MTU5NTM1MDM3MCwicm9sZXMiOlsiUk9MRV9BVUNUSU9ORUVSX0VYRUNVVE9SIiwiUk9MRV9SRVNQT05TSUJMRV9QRVJTT04iLCJST0xFX09GRklDRV9BRE1JTiJdLCJlbWFpbCI6ImV4ZWN1dG9yQHRlc3QuYXJvZGF4LmNvbSJ9.bIPp7BzTSUg0ebkSi_Zsiff7KW4IR6s5ydV9xCA4bpE3xmG588l1_2iVKFMkjJPwF5qRhNkH5t5LYnRfXQA6wv75nijCLK0rwc6ZgiTYDSDYi6IofUiTetDFaiXxndVgh6TDdhLXLOTY-FwOXLzp4IC0_F6UjqhAzD0v-pk7TbNd-W6SYrbTUqonCv89aTcoU6UstgEPFX_ri02YjTzQ33-f6LF5wMN_pO3lDmZTqwas6nXt7GTRCw2VO-oZgeC3aPdS2j_1ddKbUY5OpdETd5Q4uNHzI3Tk5-A9-zbh2U7iSeCIRqSiEu1Q2xMGz3NZ33DEBvAMXDLJ5LUIOSu7T-JiqNcOHcEw5srpUwi5Gt6NfmuK4tpLX3MkIFizlwotFqGh1l0_hHE2PAyBrAJFpMKCXYcM_DFWgehy9nN0OU-uSOaGgwldR4xvSJWjzlLiVYBC7YDJi6V8irjgYgjqUmEupv_qH2HHIVvpKXCUacLA-_K4CKwAVZ_R_4-AwEBuNEXVTwlQEky5p8d8rI7vz5RZHe-U7pS3vY-fV6LgrCeQBxu_j1X4sa0sFSnZsphK8CNoZ35ZNH9h0A9Ui33EiGYVzDLYF19c4A3ykZc9uvcEH7iboJV6n8ImgJ316Wjab4FzETQsydmmH2HLawi8hKHf4Zza0k-2Dk9rpoa2v5s' \
--data-raw '{"auction":{"documents":[],"images":[],"item":{"title":"Karlštejn","category":5,"description":"<p>Karlštejn (německy Karlstein [ˈkɑːʁlštain]) je původem středověký královský hrad, nacházející se na katastrálním území Budňany ve stejnojmenné městysi Karlštejn v&nbsp; okrese Beroun asi třináct kilometrů východně od Berouna a třicet kilometrů jihozápadně od centra Prahy. Leží rovněž uprostřed chráněné krajinné oblasti Český kras. Hrad jakožto státní instituce je ve vlastnictví České republiky a jeho správu zajišťuje Národní památkový ústav. Veřejnosti je hrad Karlštejn přístupný nepřetržitě od roku 1905,[1] a patří tak k&nbsp;jedněm z&nbsp;nejdéle zpřístupněných památek na území Česka.[2] Od 30.&nbsp;března 1962 je veden jako národní kulturní památka,[3] jejíž každoroční návštěvnost od počátku šedesátých let neklesá pod hranici 200 tisíc návštěvníků ročně.[4] Karlštejn tak dlouhodobě patří mezi desítku nejnavštěvovanějších památek České republiky – je hned druhým nejvíce vyhledávaným hradem Česka,[5] a&nbsp;v&nbsp;rámci památek spravovaných Národním památkovým ústavem si dlouhodobě drží pozici čtvrté nejnavštěvovanější památky.</p>","tags":[],"location_county_name":null,"location_coords":null,"ruian":20704429,"display_easements":"no","cadastral_office":"Karlovy Vary","easements":"Věcná břemena, výměnky a nájemní, pachtovní či předkupní práva, která prodejem nemovité věci v dražbě nezaniknou, nebyla zjištěna (§ 336a odst. 1 písm. d) o.s.ř.)."},"number":"999EX6789/20","voluntary":false,"online":false,"electronic":true,"auctioneer_office":"dGO","status":"draft","responsible_person":"Oz","start_at":"2021-02-07T12:00:00.000Z","original_end_at":"2021-02-14T12:00:00.000Z","estimated_price":99000000,"item_price":1000000,"minimal_bid":0,"caution_deposit":0,"caution_account_number":null,"caution_variable_symbol":null,"account_specific_symbol":"RČ nebo IČ","display_visits":"no","display_creditors":"no","display_preemption_right":"no","display_co_owner_right":"no","decision_during":"","location_county_name":null,"location_coords":null,"disabled_at":null,"ruian":null,"display_buyback_reservation":"no","display_accusation_of_exclusion":"no","eligible":"","obligatory":"","objection":false,"overbid":false,"overbid_end_at":null,"payment_by_credit":false,"type":"execution","recommendation":true,"visits":"Prohlídky nejsou organizovány.","creditors":"Do dražby nepřihlásil svou pohledávku žádný věřitel.","preemption_right":"Nebylo prokázáno.","co_owner_right":"Nebylo prokázáno.","buyback_reservation":"Nebyla prokázána.","accusation_of_exclusion":"Do zahájení dražby nebylo zjištěno, že by byla podána žaloba na vyloučení prodávaného předmětu dražby z exekuce."}}'
```

pokud některá pole nevyplníme, či vyplníme chybně, dostaneme odpověď **400** s výčtem chyb. 
pokud je vše v pořádku, dostaneme odpověď **201**, obsahující header `Link` s url identifikátorem vytvořené dražby.

`Link: </admin/auctions/999ex6789-20-5xq>; rel="resource"`

identifikátorem je zde `999ex6789-20-5xq`

> Postman: identifikátor uložíme do variable `auction`

## Editace dražby

použijeme identifikační link z vložení

`PUT https://www.portaldrazeb.cz/admin/auctions/999ex6789-20-5xq.json`

PUT znamená *nahradit se zachováním ID*. musíme tedy vložit všechna pole, jako při vytváření, a změnit konkrétní (např. `display_easements` a `easements`). 
pole, která chybí, jsou vynulována.

```json
{"auction":{"documents":[],"images":[],"item":{"title":"Karlštejn","category":5,"description":"<p>Karlštejn (německy Karlstein [ˈkɑːʁlštain]) je původem středověký královský hrad, nacházející se na katastrálním území Budňany ve stejnojmenné městysi Karlštejn v&nbsp; okrese Beroun asi třináct kilometrů východně od Berouna a třicet kilometrů jihozápadně od centra Prahy. Leží rovněž uprostřed chráněné krajinné oblasti Český kras. Hrad jakožto státní instituce je ve vlastnictví České republiky a jeho správu zajišťuje Národní památkový ústav. Veřejnosti je hrad Karlštejn přístupný nepřetržitě od roku 1905,[1] a patří tak k&nbsp;jedněm z&nbsp;nejdéle zpřístupněných památek na území Česka.[2] Od 30.&nbsp;března 1962 je veden jako národní kulturní památka,[3] jejíž každoroční návštěvnost od počátku šedesátých let neklesá pod hranici 200 tisíc návštěvníků ročně.[4] Karlštejn tak dlouhodobě patří mezi desítku nejnavštěvovanějších památek České republiky – je hned druhým nejvíce vyhledávaným hradem Česka,[5] a&nbsp;v&nbsp;rámci památek spravovaných Národním památkovým ústavem si dlouhodobě drží pozici čtvrté nejnavštěvovanější památky.</p>","tags":[],"location_county_name":null,"location_coords":null,"ruian":20704429,"display_easements":"yes","cadastral_office":"Karlovy Vary","easements":"Objekt je využíván veřejností"},"number":"999EX6789/20","voluntary":false,"online":false,"electronic":true,"auctioneer_office":"dGO","status":"draft","responsible_person":"Oz","start_at":"2021-02-07T12:00:00.000Z","original_end_at":"2021-02-14T12:00:00.000Z","estimated_price":99000000,"item_price":1000000,"minimal_bid":0,"caution_deposit":0,"caution_account_number":null,"caution_variable_symbol":null,"account_specific_symbol":"RČ nebo IČ","display_visits":"no","display_creditors":"no","display_preemption_right":"no","display_co_owner_right":"no","decision_during":"","location_county_name":null,"location_coords":null,"disabled_at":null,"ruian":null,"display_buyback_reservation":"no","display_accusation_of_exclusion":"no","eligible":"","obligatory":"","objection":false,"overbid":false,"overbid_end_at":null,"payment_by_credit":false,"type":"execution","recommendation":true,"visits":"Prohlídky nejsou organizovány.","creditors":"Do dražby nepřihlásil svou pohledávku žádný věřitel.","preemption_right":"Nebylo prokázáno.","co_owner_right":"Nebylo prokázáno.","buyback_reservation":"Nebyla prokázána.","accusation_of_exclusion":"Do zahájení dražby nebylo zjištěno, že by byla podána žaloba na vyloučení prodávaného předmětu dražby z exekuce."}}
```
```
curl --location --request PUT 'https://www.portaldrazeb.cz/admin/auctions/999ex6789-20-5xq.json' \
--header 'Content-Type: application/json;charset=utf-8' \
--header 'Authorization: Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJSUzI1NiJ9.eyJpYXQiOjE1OTUzNDY3NzAsImV4cCI6MTU5NTM1MDM3MCwicm9sZXMiOlsiUk9MRV9BVUNUSU9ORUVSX0VYRUNVVE9SIiwiUk9MRV9SRVNQT05TSUJMRV9QRVJTT04iLCJST0xFX09GRklDRV9BRE1JTiJdLCJlbWFpbCI6ImV4ZWN1dG9yQHRlc3QuYXJvZGF4LmNvbSJ9.bIPp7BzTSUg0ebkSi_Zsiff7KW4IR6s5ydV9xCA4bpE3xmG588l1_2iVKFMkjJPwF5qRhNkH5t5LYnRfXQA6wv75nijCLK0rwc6ZgiTYDSDYi6IofUiTetDFaiXxndVgh6TDdhLXLOTY-FwOXLzp4IC0_F6UjqhAzD0v-pk7TbNd-W6SYrbTUqonCv89aTcoU6UstgEPFX_ri02YjTzQ33-f6LF5wMN_pO3lDmZTqwas6nXt7GTRCw2VO-oZgeC3aPdS2j_1ddKbUY5OpdETd5Q4uNHzI3Tk5-A9-zbh2U7iSeCIRqSiEu1Q2xMGz3NZ33DEBvAMXDLJ5LUIOSu7T-JiqNcOHcEw5srpUwi5Gt6NfmuK4tpLX3MkIFizlwotFqGh1l0_hHE2PAyBrAJFpMKCXYcM_DFWgehy9nN0OU-uSOaGgwldR4xvSJWjzlLiVYBC7YDJi6V8irjgYgjqUmEupv_qH2HHIVvpKXCUacLA-_K4CKwAVZ_R_4-AwEBuNEXVTwlQEky5p8d8rI7vz5RZHe-U7pS3vY-fV6LgrCeQBxu_j1X4sa0sFSnZsphK8CNoZ35ZNH9h0A9Ui33EiGYVzDLYF19c4A3ykZc9uvcEH7iboJV6n8ImgJ316Wjab4FzETQsydmmH2HLawi8hKHf4Zza0k-2Dk9rpoa2v5s' \
--data-raw '{"auction":{"documents":[],"images":[],"item":{"title":"Karlštejn","category":5,"description":"<p>Karlštejn (německy Karlstein [ˈkɑːʁlštain]) je původem středověký královský hrad, nacházející se na katastrálním území Budňany ve stejnojmenné městysi Karlštejn v&nbsp; okrese Beroun asi třináct kilometrů východně od Berouna a třicet kilometrů jihozápadně od centra Prahy. Leží rovněž uprostřed chráněné krajinné oblasti Český kras. Hrad jakožto státní instituce je ve vlastnictví České republiky a jeho správu zajišťuje Národní památkový ústav. Veřejnosti je hrad Karlštejn přístupný nepřetržitě od roku 1905,[1] a patří tak k&nbsp;jedněm z&nbsp;nejdéle zpřístupněných památek na území Česka.[2] Od 30.&nbsp;března 1962 je veden jako národní kulturní památka,[3] jejíž každoroční návštěvnost od počátku šedesátých let neklesá pod hranici 200 tisíc návštěvníků ročně.[4] Karlštejn tak dlouhodobě patří mezi desítku nejnavštěvovanějších památek České republiky – je hned druhým nejvíce vyhledávaným hradem Česka,[5] a&nbsp;v&nbsp;rámci památek spravovaných Národním památkovým ústavem si dlouhodobě drží pozici čtvrté nejnavštěvovanější památky.</p>","tags":[],"location_county_name":null,"location_coords":null,"ruian":20704429,"display_easements":"yes","cadastral_office":"Karlovy Vary","easements":"Objekt je využíván veřejností"},"number":"999EX6789/20","voluntary":false,"online":false,"electronic":true,"auctioneer_office":"dGO","status":"draft","responsible_person":"Oz","start_at":"2021-02-07T12:00:00.000Z","original_end_at":"2021-02-14T12:00:00.000Z","estimated_price":99000000,"item_price":1000000,"minimal_bid":0,"caution_deposit":0,"caution_account_number":null,"caution_variable_symbol":null,"account_specific_symbol":"RČ nebo IČ","display_visits":"no","display_creditors":"no","display_preemption_right":"no","display_co_owner_right":"no","decision_during":"","location_county_name":null,"location_coords":null,"disabled_at":null,"ruian":null,"display_buyback_reservation":"no","display_accusation_of_exclusion":"no","eligible":"","obligatory":"","objection":false,"overbid":false,"overbid_end_at":null,"payment_by_credit":false,"type":"execution","recommendation":true,"visits":"Prohlídky nejsou organizovány.","creditors":"Do dražby nepřihlásil svou pohledávku žádný věřitel.","preemption_right":"Nebylo prokázáno.","co_owner_right":"Nebylo prokázáno.","buyback_reservation":"Nebyla prokázána.","accusation_of_exclusion":"Do zahájení dražby nebylo zjištěno, že by byla podána žaloba na vyloučení prodávaného předmětu dražby z exekuce."}}'
```

pokud je vše v pořádku, dostaneme odpověď **200** a v response body data dražby.

## Přiložení obrázků k dražbě

pro přiložení obrázků musíme provést dva kroky. prvně uploadovat samotný soubor a získat jeho identifikátor, a ten pak přiložit k dražbě a provést její editaci.

### Upload souboru

`POST https://www.portaldrazeb.cz/admin/auctions/upload-image`

s request header `Content-Type: multipart/form-data` a souborem v request body jako pole `upload[file]`:

```sh
curl --location --request POST 'https://www.portaldrazeb.cz/admin/auctions/upload-image' \
--header 'Authorization: Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJSUzI1NiJ9.eyJpYXQiOjE1OTUyNzE4MTksImV4cCI6MTU5NTI3NTQxOSwicm9sZXMiOlsiUk9MRV9BVUNUSU9ORUVSX0VYRUNVVE9SIiwiUk9MRV9SRVNQT05TSUJMRV9QRVJTT04iLCJST0xFX09GRklDRV9BRE1JTiJdLCJlbWFpbCI6ImV4ZWN1dG9yQHRlc3QuYXJvZGF4LmNvbSJ9.ehdax_MMhIWqJt6kPG6NKh76SnJbtbOaJ2FPmT2Pmv_SdXpZOCKuEYF3REUPutuNgUCtQ4ZNbu1QLGiN5J8OL3Xwq5fdlBpcrxJgqdu8Dw6_BLHg-udiNp265K_NfVWLgco2HVSdTyFCFtpq10xOf9A5dox7ihruLx6Bpx4l_K-8h5Q2xA72aW5u-nvionYm3QbozheeTTzvoarzN8bdsYaMJam0ohCg31ZMfXQ0kT-6kN_PEAxtp0S-F_c4g45jpbDev470rC6BGkqqnvt7z0pUwRgZDetr-NWCA6-Yu-j87affBX38LJHJoPAutoud5u_E7NHD5Fsz0tvqSfK7kty_7OqtxhKY_dYoTXGxo6eYkZxXgun4ss8GLbv-9PA-a1FpVq5jwtnJhw2ZJ6LUOwNhA3fGC2eGUrjI4Ood5ScBP3eyJ7GnVH7vg5GE-D-DVh7khStV0PA4-rVLBhMMZ8Ge_SwSP3e_3NuECKRzMl4kcY4D83Hlgg3Fnv2CYMQtlRd5kLxlYk-7cKlY1SZm8tqwcb1uxVPndQa1F9K7GF_i7Jx1ucWkB1odT1AJLGrl4auWOEzW06SSJp2pHkW3ppDPo2XaQmSqI4U0iGCktcVRaWoKyi-PzaOO58NOFGaO48bAqZs-9GB53OZRr9BZmH_4RIaTOLt_PHcymkZPjyY' \
--form 'upload[file]=@img/1.jpg'
```
maximální velikost v bytech je `20M` a mime-type `image/*`. 
pokud je vše v pořádku, dostaneme odpověď **201** a v body jako plaintext identifikátor souboru:
```
"/4c0266011e629f5ebeebee00557653d6.jpeg"
```
tento identifikátor poté použijeme v druhém kroku.

> Postman: identifikátor uložíme do variable `img-1-id`

### Přiložení k dražbě

následné přiložení obrázku je **Editace dražby**, doplněná o identifikátor obrázku. vyplníme i původní název obrázku a prioritu (int začínající nulou):

```json
{"auction":{"images":[{"file":{"uploadedFileName":"/4c0266011e629f5ebeebee00557653d6.jpeg","name":"1.jpg"},"priority":0}]}}
```

```sh
curl --location --request PUT 'https://www.portaldrazeb.cz/admin/auctions/999ex6789-20-5xq.json' \
--header 'Content-Type: application/json;charset=utf-8' \
--header 'Authorization: Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJSUzI1NiJ9.eyJpYXQiOjE1OTUzNDY3NzAsImV4cCI6MTU5NTM1MDM3MCwicm9sZXMiOlsiUk9MRV9BVUNUSU9ORUVSX0VYRUNVVE9SIiwiUk9MRV9SRVNQT05TSUJMRV9QRVJTT04iLCJST0xFX09GRklDRV9BRE1JTiJdLCJlbWFpbCI6ImV4ZWN1dG9yQHRlc3QuYXJvZGF4LmNvbSJ9.bIPp7BzTSUg0ebkSi_Zsiff7KW4IR6s5ydV9xCA4bpE3xmG588l1_2iVKFMkjJPwF5qRhNkH5t5LYnRfXQA6wv75nijCLK0rwc6ZgiTYDSDYi6IofUiTetDFaiXxndVgh6TDdhLXLOTY-FwOXLzp4IC0_F6UjqhAzD0v-pk7TbNd-W6SYrbTUqonCv89aTcoU6UstgEPFX_ri02YjTzQ33-f6LF5wMN_pO3lDmZTqwas6nXt7GTRCw2VO-oZgeC3aPdS2j_1ddKbUY5OpdETd5Q4uNHzI3Tk5-A9-zbh2U7iSeCIRqSiEu1Q2xMGz3NZ33DEBvAMXDLJ5LUIOSu7T-JiqNcOHcEw5srpUwi5Gt6NfmuK4tpLX3MkIFizlwotFqGh1l0_hHE2PAyBrAJFpMKCXYcM_DFWgehy9nN0OU-uSOaGgwldR4xvSJWjzlLiVYBC7YDJi6V8irjgYgjqUmEupv_qH2HHIVvpKXCUacLA-_K4CKwAVZ_R_4-AwEBuNEXVTwlQEky5p8d8rI7vz5RZHe-U7pS3vY-fV6LgrCeQBxu_j1X4sa0sFSnZsphK8CNoZ35ZNH9h0A9Ui33EiGYVzDLYF19c4A3ykZc9uvcEH7iboJV6n8ImgJ316Wjab4FzETQsydmmH2HLawi8hKHf4Zza0k-2Dk9rpoa2v5s' \
--data-raw '{"auction":{"documents":[],"images":[{"file":{"uploadedFileName":"/4c0266011e629f5ebeebee00557653d6.jpeg","name":"1.jpg"},"priority":0}],"item":{"title":"Karlštejn","category":5,"description":"<p>Karlštejn (německy Karlstein [ˈkɑːʁlštain]) je původem středověký královský hrad, nacházející se na katastrálním území Budňany ve stejnojmenné městysi Karlštejn v&nbsp; okrese Beroun asi třináct kilometrů východně od Berouna a třicet kilometrů jihozápadně od centra Prahy. Leží rovněž uprostřed chráněné krajinné oblasti Český kras. Hrad jakožto státní instituce je ve vlastnictví České republiky a jeho správu zajišťuje Národní památkový ústav. Veřejnosti je hrad Karlštejn přístupný nepřetržitě od roku 1905,[1] a patří tak k&nbsp;jedněm z&nbsp;nejdéle zpřístupněných památek na území Česka.[2] Od 30.&nbsp;března 1962 je veden jako národní kulturní památka,[3] jejíž každoroční návštěvnost od počátku šedesátých let neklesá pod hranici 200 tisíc návštěvníků ročně.[4] Karlštejn tak dlouhodobě patří mezi desítku nejnavštěvovanějších památek České republiky – je hned druhým nejvíce vyhledávaným hradem Česka,[5] a&nbsp;v&nbsp;rámci památek spravovaných Národním památkovým ústavem si dlouhodobě drží pozici čtvrté nejnavštěvovanější památky.</p>","tags":[],"location_county_name":null,"location_coords":null,"ruian":20704429,"display_easements":"yes","cadastral_office":"Karlovy Vary","easements":"Objekt je využíván veřejností"},"number":"999EX6789/20","voluntary":false,"online":false,"electronic":true,"auctioneer_office":"dGO","status":"draft","responsible_person":"Oz","start_at":"2021-02-07T12:00:00.000Z","original_end_at":"2021-02-14T12:00:00.000Z","estimated_price":99000000,"item_price":1000000,"minimal_bid":0,"caution_deposit":0,"caution_account_number":null,"caution_variable_symbol":null,"account_specific_symbol":"RČ nebo IČ","display_visits":"no","display_creditors":"no","display_preemption_right":"no","display_co_owner_right":"no","decision_during":"","location_county_name":null,"location_coords":null,"disabled_at":null,"ruian":null,"display_buyback_reservation":"no","display_accusation_of_exclusion":"no","eligible":"","obligatory":"","objection":false,"overbid":false,"overbid_end_at":null,"payment_by_credit":false,"type":"execution","recommendation":true,"visits":"Prohlídky nejsou organizovány.","creditors":"Do dražby nepřihlásil svou pohledávku žádný věřitel.","preemption_right":"Nebylo prokázáno.","co_owner_right":"Nebylo prokázáno.","buyback_reservation":"Nebyla prokázána.","accusation_of_exclusion":"Do zahájení dražby nebylo zjištěno, že by byla podána žaloba na vyloučení prodávaného předmětu dražby z exekuce."}}'
```

pokud je vše v pořádku, odpověď **200**, v response body data dražby.

nyní ale data dražby obsahují údaje o obrázku. při následné editaci dražby je nutné tato data také odeslat, jinak dojde k jeho vymazání.

```json
{"images":[{"pathname":"/auctions/eQW/4c0266011e629f5ebeebee00557653d6.jpeg","path":"images://auctions/eQW","mime_type":"image/jpeg","size":64102,"original_name":"obrázek 1.jpg","description":null,"created_at":"2020-07-20T19:08:39.545+00:00","updated_at":"2020-07-20T19:08:39.551+00:00","hash":"yJE","width":500,"height":463,"priority":0}]}
```
podstatná jsou pole `hash` a `priority`:
```json
{
    "hash": "yJE",
    "priority": 0
}
```

jinak řečeno, každý obrázek musí obsahovat buď pole `file`, pokud se jedná o přiložení nového, uploadovaného obrázku, nebo pole `hash`, pokud se jedná o uložení existujícího, a pole `priority`.

> Postman: hash uložíme do variable `img-1-hash`

Přiložíme druhý obrázek.

### Upload souboru

```sh
curl --location --request POST 'https://www.portaldrazeb.cz/admin/auctions/upload-image' \
--header 'Authorization: Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJSUzI1NiJ9.eyJpYXQiOjE1OTUyNzE4MTksImV4cCI6MTU5NTI3NTQxOSwicm9sZXMiOlsiUk9MRV9BVUNUSU9ORUVSX0VYRUNVVE9SIiwiUk9MRV9SRVNQT05TSUJMRV9QRVJTT04iLCJST0xFX09GRklDRV9BRE1JTiJdLCJlbWFpbCI6ImV4ZWN1dG9yQHRlc3QuYXJvZGF4LmNvbSJ9.ehdax_MMhIWqJt6kPG6NKh76SnJbtbOaJ2FPmT2Pmv_SdXpZOCKuEYF3REUPutuNgUCtQ4ZNbu1QLGiN5J8OL3Xwq5fdlBpcrxJgqdu8Dw6_BLHg-udiNp265K_NfVWLgco2HVSdTyFCFtpq10xOf9A5dox7ihruLx6Bpx4l_K-8h5Q2xA72aW5u-nvionYm3QbozheeTTzvoarzN8bdsYaMJam0ohCg31ZMfXQ0kT-6kN_PEAxtp0S-F_c4g45jpbDev470rC6BGkqqnvt7z0pUwRgZDetr-NWCA6-Yu-j87affBX38LJHJoPAutoud5u_E7NHD5Fsz0tvqSfK7kty_7OqtxhKY_dYoTXGxo6eYkZxXgun4ss8GLbv-9PA-a1FpVq5jwtnJhw2ZJ6LUOwNhA3fGC2eGUrjI4Ood5ScBP3eyJ7GnVH7vg5GE-D-DVh7khStV0PA4-rVLBhMMZ8Ge_SwSP3e_3NuECKRzMl4kcY4D83Hlgg3Fnv2CYMQtlRd5kLxlYk-7cKlY1SZm8tqwcb1uxVPndQa1F9K7GF_i7Jx1ucWkB1odT1AJLGrl4auWOEzW06SSJp2pHkW3ppDPo2XaQmSqI4U0iGCktcVRaWoKyi-PzaOO58NOFGaO48bAqZs-9GB53OZRr9BZmH_4RIaTOLt_PHcymkZPjyY' \
--form 'upload[file]=@img/2.jpg'
```
dostaneme odpověď **201** a v body jako plaintext identifikátor souboru:
```
"/3c1dbd4e215e51e8a63217396853ced5.jpeg"
```

> Postman: identifikátor uložíme do variable `img-2-id`

### Přiložení k dražbě

opět jako v předchozím případě, ale tentokrát pole `images` obsahuje dva obrázky - první, již uložený, a druhý, nově přiložený:
```json
{"images":[{"file":{"uploadedFileName":"/3c1dbd4e215e51e8a63217396853ced5.jpeg","name":"2.jpg"},"priority":1},{"hash":"yJE","priority":0}]}
```


```sh
curl --location --request PUT 'https://www.portaldrazeb.cz/admin/auctions/999ex6789-20-5xq.json' \
--header 'Content-Type: application/json;charset=utf-8' \
--header 'Authorization: Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJSUzI1NiJ9.eyJpYXQiOjE1OTUzNTA0NzQsImV4cCI6MTU5NTM1NDA3NCwicm9sZXMiOlsiUk9MRV9BVUNUSU9ORUVSX0VYRUNVVE9SIiwiUk9MRV9SRVNQT05TSUJMRV9QRVJTT04iLCJST0xFX09GRklDRV9BRE1JTiJdLCJlbWFpbCI6ImV4ZWN1dG9yQHRlc3QuYXJvZGF4LmNvbSJ9.MyGgUEW8c49vmGRd4c54456feCOuvTvTLtrstBp_tO1vu8hC3gK8jWVM4DfpscjOj--0l3TbujKcS7BzFU0V8RR6tzxZb0kVnUHgH9ss-BB3VOCmwsfKZe_njA_zDJgUG9a_a2XKTN0KSJ3SEDyMmQuQC9084sHKMCj2QtEGRSCTiv4se2a6hMaQhNFl97SK9hT7iLuLiSmLlYXCLU5X_3RDNNELH2XIYu66tIKdnSl5l5HtzvmD8Q_2GIIobBGL2zu4JA5WXU-xWgP3_h8BcIbDZs6ETFoO-u_QS-Rt2NhPS16TAPrp3t5sHYVQjPPRELCiqULoS0pQgan5UkfgvL4QPb_Xeoxg0CLlmrp7x08PidyE3bg6wSrH-4jxAM6E2kfvd8m5ZKDGjdjwqKgKW_UoEHF8yNtyoL1LwoVCe1HUofbFsCfpTvVJ71k7Uxr3ydiXzfTB8PaeoUs47VhGFBE3uhK0iX8IjcKsEdx0kV2rg9eWaaFrbJ_J4EG2m2dVfW7VSFtq2Eq9q4OHwkpJTQo26l8rCi5tCNYKfKVVVktrOnwmAG9wv6KarB_MjtZxClAZ_UQ_HsHeOmm1HY1qDb9nBoRgmTqyZNuW48DNLEu7RWneyt90v0RWS5kHPviqmh_2On45iHMvU3Ps2mWHrvmIAEzb2yAe5T9rMGyEFEM' \
--data-raw '{"auction":{"documents":[],"images":[{"file":{"uploadedFileName":"/3c1dbd4e215e51e8a63217396853ced5.jpeg","name":"2.jpg"},"priority":1},{"hash":"yJE","priority":0}],"item":{"title":"Karlštejn","category":5,"description":"<p>Karlštejn (německy Karlstein [ˈkɑːʁlštain]) je původem středověký královský hrad, nacházející se na katastrálním území Budňany ve stejnojmenné městysi Karlštejn v&nbsp; okrese Beroun asi třináct kilometrů východně od Berouna a třicet kilometrů jihozápadně od centra Prahy. Leží rovněž uprostřed chráněné krajinné oblasti Český kras. Hrad jakožto státní instituce je ve vlastnictví České republiky a jeho správu zajišťuje Národní památkový ústav. Veřejnosti je hrad Karlštejn přístupný nepřetržitě od roku 1905,[1] a patří tak k&nbsp;jedněm z&nbsp;nejdéle zpřístupněných památek na území Česka.[2] Od 30.&nbsp;března 1962 je veden jako národní kulturní památka,[3] jejíž každoroční návštěvnost od počátku šedesátých let neklesá pod hranici 200 tisíc návštěvníků ročně.[4] Karlštejn tak dlouhodobě patří mezi desítku nejnavštěvovanějších památek České republiky – je hned druhým nejvíce vyhledávaným hradem Česka,[5] a&nbsp;v&nbsp;rámci památek spravovaných Národním památkovým ústavem si dlouhodobě drží pozici čtvrté nejnavštěvovanější památky.</p>","tags":[],"location_county_name":null,"location_coords":null,"ruian":20704429,"display_easements":"yes","cadastral_office":"Karlovy Vary","easements":"Objekt je využíván veřejností"},"number":"999EX6789/20","voluntary":false,"online":false,"electronic":true,"auctioneer_office":"dGO","status":"draft","responsible_person":"Oz","start_at":"2021-02-07T12:00:00.000Z","original_end_at":"2021-02-14T12:00:00.000Z","estimated_price":99000000,"item_price":1000000,"minimal_bid":0,"caution_deposit":0,"caution_account_number":null,"caution_variable_symbol":null,"account_specific_symbol":"RČ nebo IČ","display_visits":"no","display_creditors":"no","display_preemption_right":"no","display_co_owner_right":"no","decision_during":"","location_county_name":null,"location_coords":null,"disabled_at":null,"ruian":null,"display_buyback_reservation":"no","display_accusation_of_exclusion":"no","eligible":"","obligatory":"","objection":false,"overbid":false,"overbid_end_at":null,"payment_by_credit":false,"type":"execution","recommendation":true,"visits":"Prohlídky nejsou organizovány.","creditors":"Do dražby nepřihlásil svou pohledávku žádný věřitel.","preemption_right":"Nebylo prokázáno.","co_owner_right":"Nebylo prokázáno.","buyback_reservation":"Nebyla prokázána.","accusation_of_exclusion":"Do zahájení dražby nebylo zjištěno, že by byla podána žaloba na vyloučení prodávaného předmětu dražby z exekuce."}}'
```
pokud je vše v pořádku, odpověď **200**, v response body data dražby.

> Postman: hash uložíme do variable `img-2-hash`

## Přiložení dokumentů k dražbě

pro přiložení dokumentů musíme provést dva kroky. prvně uploadovat samotný soubor a získat jeho identifikátor, a ten pak přiložit k dražbě.

### Upload souboru

`POST https://www.portaldrazeb.cz/admin/auctions/upload-document`

s request header `Content-Type: multipart/form-data` a souborem v request body jako pole `upload[file]`:

```sh
curl --location --request POST 'https://www.portaldrazeb.cz/admin/auctions/upload-document' \
--header 'Authorization: Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJSUzI1NiJ9.eyJpYXQiOjE1OTUyNzg4NTAsImV4cCI6MTU5NTI4MjQ1MCwicm9sZXMiOlsiUk9MRV9BVUNUSU9ORUVSX0VYRUNVVE9SIiwiUk9MRV9SRVNQT05TSUJMRV9QRVJTT04iLCJST0xFX09GRklDRV9BRE1JTiJdLCJlbWFpbCI6ImV4ZWN1dG9yQHRlc3QuYXJvZGF4LmNvbSJ9.rQzjTg8GNWRVNLKY67lAo-84kVGNNGczEPMD9_hRcvzOFSGRWkzF7CfOn3nwW8CsIndRBNejKxdKBBSZcSApOFNhwPcSKWNfic_wbImMQo9c_n89nPWt3i5jiF4yEERfT7YTCj9WTjvVlddrYCn9bIKv1qplnHF-YFfG96S9FCWXkdFOgzo9YzXS7QaZJKNwQC1NZStfTaj7sLzyUaUjQ9jtKI-UKJB9Ni0NQwcfmsyqHrjts63cuju7s-6lfhYFbuKZUyZvur1ZvCkvt_ENNnLhy0MDf0SNCPwQlGe92AUXh89LB6ZtWR3_-lifAnTPUSrriXQmC-Okmx2O6tDzl1ivgWRPAuhKaIbICgwZkMkctzEWZLCWBBQxgqFWY25nms0iJEJlbzgqTE87tywulhE12A3uj5DMQyKvSFEMxj9yVl0NAiDITbajBpODzpO9ZRJAyGvQHA7Ia5Qt1MpU19WR46IGUuyNp7cxcagN4PeCeTF6fgZIGKZXigyN2eufeB1oR0VdgAXQHvW7FBXjFWRrZo74v43i8IEE3q1eVHGVF52X-p7nr_1h1UhP7id06Nw2UDR0bND4tuJsFfwZp0WzRCYhgGrT1VcQz-aBOhTh8uFsi30CwaGcotVEdV9BzPS_Hn0ZeeFSF4aGtLHsGSptDEuodsNREg7a0YGY1zk' \
--form 'upload[file]=@doc/1.pdf'
```
maximální velikost v bytech je `20M` a mime-type `application/pdf`. 
pokud je vše v pořádku, dostaneme odpověď **201** a v body jako plaintext identifikátor souboru:
```
"/097d51ab814093029a01602198613592.pdf"
```
tento identifikátor poté použijeme v druhém kroku.

> Postman: identifikátor uložíme do variable `doc-1-id`

### Přiložení k dražbě

následné přiložení dokumentu je **samostatný endpoint**, který vrací identifikátor dokumentu. vyplníme i původní název dokumentu a jeho typ (string):

`POST https://www.portaldrazeb.cz/admin/auction-documents/999ex6789-20-5xq.json`

```json
{"document":{"document_type":"auction_decree","file":{"uploadedFileName":"/097d51ab814093029a01602198613592.pdf","originalFileName":"1.pdf"}}}
```

enum typů dokumentu:

```json
{
  "auction_decree", //dražební vyhláška
  "expert_report", //znalecký posudek
  "expert_report_appendix", //dodatek znaleckého posudku
  "resolution_post", //usnesení po
  "resolution_pre", //usnesení před
  "resolution_award", //usnesení o příklepu
  "resolution_overbid", //usnesení o předražku
  "resolution_defer", //usnesení o odročení/upuštění
  "resolution_cancel", //usnesení o zrušení/nekonání
  "resolution_paid", //usnesení o uhrazení
  "other_doc", //ostatní
  "initiation_notice", //oznámení o zahájení
}
```

```sh
curl --location --request POST 'https://www.portaldrazeb.cz/admin/auction-documents/999ex6789-20-5xq.json' \
--header 'Content-Type: application/json;charset=utf-8' \
--header 'Authorization: Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJSUzI1NiJ9.eyJpYXQiOjE1OTUzNTEwNTAsImV4cCI6MTU5NTM1NDY1MCwicm9sZXMiOlsiUk9MRV9BVUNUSU9ORUVSX0VYRUNVVE9SIiwiUk9MRV9SRVNQT05TSUJMRV9QRVJTT04iLCJST0xFX09GRklDRV9BRE1JTiJdLCJlbWFpbCI6ImV4ZWN1dG9yQHRlc3QuYXJvZGF4LmNvbSJ9.F23k_OlkseuskzGLZ3j5pTi-PjYUmS8TPZzDtzNMF6PLiliMHGyuPkxgDQgUZwdogQMnrCTBa210eBRHE4eoq9RLnhFU58XPO8ifcSg4DLleJhqIFqCXb2nt-LXF9xU0-FFZTekVTjWvQPz2a4dpuDARg5QwZtM48K4cOtG4je9-iQmlfjx_jj91AhgUWB315USfC2U0exjMsxD37m3Qn8B_FCNeaDSWz_Cs_ixcggh6CRM3BxOtYdQUxxLccxsvwGDEWrvCyllsXmGHJq_4B0tyOqjxTZNQ_kWUxVao-Tv6cdRuDAxYJSWiEVplFLdOIiv8J9CYgTcy011ujj44DzmrtzXx2IBSpZ0sH2tS_xRqkVWWPZeqsZrGcBhnsmi6McAf7bsDHvAt-q2ca4h0I2rpZzTBpTcLS2jugFAmJMXQFVALMs8uyD4kU7ps6tMjv_dh5KyqNd2exDtEsSYaZZHRrHJKiA3s_1__Ma41BLEMUwimFlwASiVt4I2SrmdiODrZachyuZBtcUA25woJG6GhsyhfAIKxRMjl6cj2p_jo-vxW9m65ZT4VyNb6ddJ5dZ2CLjR0TpjiXL3mGkDDxBBV_za2N9DvRw3hdtFihvGUgNdYQ_YrwH0ZkEB43my71c3_pF0ePMmJ7NMGIC2lgtaZ-grDWNO87wDwLK3M-yQ' \
--data-raw '{"document":{"document_type":"auction_decree","file":{"uploadedFileName":"/097d51ab814093029a01602198613592.pdf","originalFileName":"1.pdf"}}}'
```

pokud je vše v pořádku, odpověď **201**, v response body data dokumentu.

nyní data dražby obsahují údaje o dokumentu. pro vymazání dokumentu je potřeba zavolat endpoint pro vymazání, viz další krok.

```json
{"pathname":"/auctions/5xq/097d51ab814093029a01602198613592.pdf","path":"documents://auctions/5xq","mime_type":"application/pdf","size":22673,"original_name":"dražební vyhláška 1.pdf","created_at":"2020-07-20T19:08:39.545+00:00","updated_at":"2020-07-20T19:08:39.551+00:00","hash":"jNg","document_type":"auction_decree"}
```
podstatná jsou pole `hash` a `document_type`:
```json
{
    "hash": "jNg",
    "document_type": "auction_decree"
}
```

> Postman: hash uložíme do variable `doc-1-hash`

Přiložíme druhý dokument.

### Upload souboru

```sh
curl --location --request POST 'https://www.portaldrazeb.cz/admin/auctions/upload-document' \
--header 'Authorization: Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJSUzI1NiJ9.eyJpYXQiOjE1OTUyNzg4NTAsImV4cCI6MTU5NTI4MjQ1MCwicm9sZXMiOlsiUk9MRV9BVUNUSU9ORUVSX0VYRUNVVE9SIiwiUk9MRV9SRVNQT05TSUJMRV9QRVJTT04iLCJST0xFX09GRklDRV9BRE1JTiJdLCJlbWFpbCI6ImV4ZWN1dG9yQHRlc3QuYXJvZGF4LmNvbSJ9.rQzjTg8GNWRVNLKY67lAo-84kVGNNGczEPMD9_hRcvzOFSGRWkzF7CfOn3nwW8CsIndRBNejKxdKBBSZcSApOFNhwPcSKWNfic_wbImMQo9c_n89nPWt3i5jiF4yEERfT7YTCj9WTjvVlddrYCn9bIKv1qplnHF-YFfG96S9FCWXkdFOgzo9YzXS7QaZJKNwQC1NZStfTaj7sLzyUaUjQ9jtKI-UKJB9Ni0NQwcfmsyqHrjts63cuju7s-6lfhYFbuKZUyZvur1ZvCkvt_ENNnLhy0MDf0SNCPwQlGe92AUXh89LB6ZtWR3_-lifAnTPUSrriXQmC-Okmx2O6tDzl1ivgWRPAuhKaIbICgwZkMkctzEWZLCWBBQxgqFWY25nms0iJEJlbzgqTE87tywulhE12A3uj5DMQyKvSFEMxj9yVl0NAiDITbajBpODzpO9ZRJAyGvQHA7Ia5Qt1MpU19WR46IGUuyNp7cxcagN4PeCeTF6fgZIGKZXigyN2eufeB1oR0VdgAXQHvW7FBXjFWRrZo74v43i8IEE3q1eVHGVF52X-p7nr_1h1UhP7id06Nw2UDR0bND4tuJsFfwZp0WzRCYhgGrT1VcQz-aBOhTh8uFsi30CwaGcotVEdV9BzPS_Hn0ZeeFSF4aGtLHsGSptDEuodsNREg7a0YGY1zk' \
--form 'upload[file]=@doc/2.pdf'
```
dostaneme odpověď **201** a v body jako plaintext identifikátor souboru:
```
"/718c569c0c5b792497f5ac416fd64d29.pdf"
```

> Postman: identifikátor uložíme do variable `doc-2-id`

### Přiložení k dražbě

opět jako v předchozím případě, zavoláme **samostatný endpoint**, který vrací identifikátor dokumentu. vyplníme i původní název dokumentu a jeho typ (string):

`POST https://www.portaldrazeb.cz/admin/auction-documents/999ex6789-20-5xq.json`

```json
{"document":{"document_type":"expert_report","file":{"uploadedFileName":"/718c569c0c5b792497f5ac416fd64d29.pdf","originalFileName":"2.pdf"}}}
```


```sh
curl --location --request POST 'https://www.portaldrazeb.cz/admin/auction-documents/999ex6789-20-5xq.json' \
--header 'Content-Type: application/json;charset=utf-8' \
--header 'Authorization: Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJSUzI1NiJ9.eyJpYXQiOjE1OTUzNTEwNTAsImV4cCI6MTU5NTM1NDY1MCwicm9sZXMiOlsiUk9MRV9BVUNUSU9ORUVSX0VYRUNVVE9SIiwiUk9MRV9SRVNQT05TSUJMRV9QRVJTT04iLCJST0xFX09GRklDRV9BRE1JTiJdLCJlbWFpbCI6ImV4ZWN1dG9yQHRlc3QuYXJvZGF4LmNvbSJ9.F23k_OlkseuskzGLZ3j5pTi-PjYUmS8TPZzDtzNMF6PLiliMHGyuPkxgDQgUZwdogQMnrCTBa210eBRHE4eoq9RLnhFU58XPO8ifcSg4DLleJhqIFqCXb2nt-LXF9xU0-FFZTekVTjWvQPz2a4dpuDARg5QwZtM48K4cOtG4je9-iQmlfjx_jj91AhgUWB315USfC2U0exjMsxD37m3Qn8B_FCNeaDSWz_Cs_ixcggh6CRM3BxOtYdQUxxLccxsvwGDEWrvCyllsXmGHJq_4B0tyOqjxTZNQ_kWUxVao-Tv6cdRuDAxYJSWiEVplFLdOIiv8J9CYgTcy011ujj44DzmrtzXx2IBSpZ0sH2tS_xRqkVWWPZeqsZrGcBhnsmi6McAf7bsDHvAt-q2ca4h0I2rpZzTBpTcLS2jugFAmJMXQFVALMs8uyD4kU7ps6tMjv_dh5KyqNd2exDtEsSYaZZHRrHJKiA3s_1__Ma41BLEMUwimFlwASiVt4I2SrmdiODrZachyuZBtcUA25woJG6GhsyhfAIKxRMjl6cj2p_jo-vxW9m65ZT4VyNb6ddJ5dZ2CLjR0TpjiXL3mGkDDxBBV_za2N9DvRw3hdtFihvGUgNdYQ_YrwH0ZkEB43my71c3_pF0ePMmJ7NMGIC2lgtaZ-grDWNO87wDwLK3M-yQ' \
--data-raw '{"document":{"document_type":"expert_report","file":{"uploadedFileName":"/718c569c0c5b792497f5ac416fd64d29.pdf","originalFileName":"2.pdf"}}}'
```
pokud je vše v pořádku, odpověď **201**, v body response data dokumentu.

```json
{"pathname":"/auctions/5xq/718c569c0c5b792497f5ac416fd64d29.pdf","path":"documents://auctions/5xq","mime_type":"application/pdf","size":22673,"original_name":"znalecký posudek 1.pdf","created_at":"2020-07-20T19:08:39.545+00:00","updated_at":"2020-07-20T19:08:39.551+00:00","hash":"e7F","document_type":"expert_report"}
```
podstatná jsou pole `hash` a `document_type`:
```json
{
    "hash": "e7F",
    "document_type": "expert_report"
}
```

> Postman: hash uložíme do variable `doc-2-hash`

## Smazání dokumentu

pro smazání dokumentu potřebujeme jeho hash, zavoláme tento endpoint:

`DELETE https://www.portaldrazeb.cz/admin/auction-documents/999ex6789-20-5xq/e7F.json`

```sh
curl --location --request DELETE 'https://www.portaldrazeb.cz/admin/auction-documents/999ex6789-20-5xq/e7F.json' \
--header 'Authorization: Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJSUzI1NiJ9.eyJpYXQiOjE1OTUzNTEwNTAsImV4cCI6MTU5NTM1NDY1MCwicm9sZXMiOlsiUk9MRV9BVUNUSU9ORUVSX0VYRUNVVE9SIiwiUk9MRV9SRVNQT05TSUJMRV9QRVJTT04iLCJST0xFX09GRklDRV9BRE1JTiJdLCJlbWFpbCI6ImV4ZWN1dG9yQHRlc3QuYXJvZGF4LmNvbSJ9.F23k_OlkseuskzGLZ3j5pTi-PjYUmS8TPZzDtzNMF6PLiliMHGyuPkxgDQgUZwdogQMnrCTBa210eBRHE4eoq9RLnhFU58XPO8ifcSg4DLleJhqIFqCXb2nt-LXF9xU0-FFZTekVTjWvQPz2a4dpuDARg5QwZtM48K4cOtG4je9-iQmlfjx_jj91AhgUWB315USfC2U0exjMsxD37m3Qn8B_FCNeaDSWz_Cs_ixcggh6CRM3BxOtYdQUxxLccxsvwGDEWrvCyllsXmGHJq_4B0tyOqjxTZNQ_kWUxVao-Tv6cdRuDAxYJSWiEVplFLdOIiv8J9CYgTcy011ujj44DzmrtzXx2IBSpZ0sH2tS_xRqkVWWPZeqsZrGcBhnsmi6McAf7bsDHvAt-q2ca4h0I2rpZzTBpTcLS2jugFAmJMXQFVALMs8uyD4kU7ps6tMjv_dh5KyqNd2exDtEsSYaZZHRrHJKiA3s_1__Ma41BLEMUwimFlwASiVt4I2SrmdiODrZachyuZBtcUA25woJG6GhsyhfAIKxRMjl6cj2p_jo-vxW9m65ZT4VyNb6ddJ5dZ2CLjR0TpjiXL3mGkDDxBBV_za2N9DvRw3hdtFihvGUgNdYQ_YrwH0ZkEB43my71c3_pF0ePMmJ7NMGIC2lgtaZ-grDWNO87wDwLK3M-yQ' \
```

pokud je vše v pořádku, odpověď **200**

## Editace dražby

provedeme finální editaci dražby před zveřejněním. ta nyní obsahuje dva uložené obrázky a dva uložené dokumenty.
přidáme údaje `minimal_bid, caution_deposit, caution_account_number, caution_variable_symbol`.

```sh
curl --location --request PUT 'https://www.portaldrazeb.cz/admin/auctions/999ex6789-20-5xq.json' \
--header 'Content-Type: application/json;charset=utf-8' \
--header 'Authorization: Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJSUzI1NiJ9.eyJpYXQiOjE1OTUzNTEwNTAsImV4cCI6MTU5NTM1NDY1MCwicm9sZXMiOlsiUk9MRV9BVUNUSU9ORUVSX0VYRUNVVE9SIiwiUk9MRV9SRVNQT05TSUJMRV9QRVJTT04iLCJST0xFX09GRklDRV9BRE1JTiJdLCJlbWFpbCI6ImV4ZWN1dG9yQHRlc3QuYXJvZGF4LmNvbSJ9.F23k_OlkseuskzGLZ3j5pTi-PjYUmS8TPZzDtzNMF6PLiliMHGyuPkxgDQgUZwdogQMnrCTBa210eBRHE4eoq9RLnhFU58XPO8ifcSg4DLleJhqIFqCXb2nt-LXF9xU0-FFZTekVTjWvQPz2a4dpuDARg5QwZtM48K4cOtG4je9-iQmlfjx_jj91AhgUWB315USfC2U0exjMsxD37m3Qn8B_FCNeaDSWz_Cs_ixcggh6CRM3BxOtYdQUxxLccxsvwGDEWrvCyllsXmGHJq_4B0tyOqjxTZNQ_kWUxVao-Tv6cdRuDAxYJSWiEVplFLdOIiv8J9CYgTcy011ujj44DzmrtzXx2IBSpZ0sH2tS_xRqkVWWPZeqsZrGcBhnsmi6McAf7bsDHvAt-q2ca4h0I2rpZzTBpTcLS2jugFAmJMXQFVALMs8uyD4kU7ps6tMjv_dh5KyqNd2exDtEsSYaZZHRrHJKiA3s_1__Ma41BLEMUwimFlwASiVt4I2SrmdiODrZachyuZBtcUA25woJG6GhsyhfAIKxRMjl6cj2p_jo-vxW9m65ZT4VyNb6ddJ5dZ2CLjR0TpjiXL3mGkDDxBBV_za2N9DvRw3hdtFihvGUgNdYQ_YrwH0ZkEB43my71c3_pF0ePMmJ7NMGIC2lgtaZ-grDWNO87wDwLK3M-yQ' \
--data-raw '{"auction":{"documents":[{"hash":"2Jq","document_type":"expert_report"},{"hash":"jxA","document_type":"auction_decree"}],"images":[{"hash":"6PZ","priority":1},{"hash":"37q","priority":0}],"item":{"title":"Karlštejn","category":5,"description":"<p>Karlštejn (německy Karlstein [ˈkɑːʁlštain]) je původem středověký královský hrad, nacházející se na katastrálním území Budňany ve stejnojmenné městysi Karlštejn v&nbsp; okrese Beroun asi třináct kilometrů východně od Berouna a třicet kilometrů jihozápadně od centra Prahy. Leží rovněž uprostřed chráněné krajinné oblasti Český kras. Hrad jakožto státní instituce je ve vlastnictví České republiky a jeho správu zajišťuje Národní památkový ústav. Veřejnosti je hrad Karlštejn přístupný nepřetržitě od roku 1905,[1] a patří tak k&nbsp;jedněm z&nbsp;nejdéle zpřístupněných památek na území Česka.[2] Od 30.&nbsp;března 1962 je veden jako národní kulturní památka,[3] jejíž každoroční návštěvnost od počátku šedesátých let neklesá pod hranici 200 tisíc návštěvníků ročně.[4] Karlštejn tak dlouhodobě patří mezi desítku nejnavštěvovanějších památek České republiky – je hned druhým nejvíce vyhledávaným hradem Česka,[5] a&nbsp;v&nbsp;rámci památek spravovaných Národním památkovým ústavem si dlouhodobě drží pozici čtvrté nejnavštěvovanější památky.</p>","tags":[],"location_county_name":"Jihlava","location_latitude":49.396474,"location_longitude":15.598578,"ruian":null,"display_easements":"yes","cadastral_office":"Karlovy Vary","easements":"Objekt je využíván veřejností"},"number":"999EX7890/20","voluntary":false,"online":false,"electronic":true,"auctioneer_office":"dGO","status":"draft","responsible_person":"Oz","start_at":"2021-02-07T12:00:00.000Z","original_end_at":"2021-02-14T12:00:00.000Z","estimated_price":99000000,"item_price":1000000,"minimal_bid":5000,"caution_deposit":100000,"caution_account_number":"654321/1234","caution_variable_symbol":"987654","account_specific_symbol":"RČ nebo IČ","display_visits":"no","display_creditors":"no","display_preemption_right":"no","display_co_owner_right":"no","decision_during":"","location_county_name":null,"location_coords":null,"disabled_at":null,"ruian":null,"display_buyback_reservation":"no","display_accusation_of_exclusion":"no","eligible":"","obligatory":"","objection":false,"overbid":false,"overbid_end_at":null,"payment_by_credit":false,"type":"execution","recommendation":true,"visits":"Prohlídky nejsou organizovány.","creditors":"Do dražby nepřihlásil svou pohledávku žádný věřitel.","preemption_right":"Nebylo prokázáno.","co_owner_right":"Nebylo prokázáno.","buyback_reservation":"Nebyla prokázána.","accusation_of_exclusion":"Do zahájení dražby nebylo zjištěno, že by byla podána žaloba na vyloučení prodávaného předmětu dražby z exekuce."}}'
```
pokud je vše v pořádku, odpověď **200**, v response body data dražby.

## Zveřejnění dražby

`PATCH https://www.portaldrazeb.cz/admin/auctions/999ex6789-20-5xq.json`

slouží pro změnu stavu dražby.
do request body vložíme název přechodu (string):
```json
{"transition":"to_upcoming"}
```
enum přechodů dražby:
```json
{
  "to_draft", //nezveřejněná
  "to_upcoming", //připravovaná
  "to_deleted", //smazaná
  "to_paid", //uhrazená
  "to_deferred", //odročená
  "to_cancelled", //zrušená
}
```

```sh
curl --location --request PATCH 'https://www.portaldrazeb.cz/admin/auctions/999ex6789-20-5xq.json' \
--header 'Content-Type: application/json;charset=utf-8' \
--header 'Authorization: Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJSUzI1NiJ9.eyJpYXQiOjE1OTUzNTEwNTAsImV4cCI6MTU5NTM1NDY1MCwicm9sZXMiOlsiUk9MRV9BVUNUSU9ORUVSX0VYRUNVVE9SIiwiUk9MRV9SRVNQT05TSUJMRV9QRVJTT04iLCJST0xFX09GRklDRV9BRE1JTiJdLCJlbWFpbCI6ImV4ZWN1dG9yQHRlc3QuYXJvZGF4LmNvbSJ9.F23k_OlkseuskzGLZ3j5pTi-PjYUmS8TPZzDtzNMF6PLiliMHGyuPkxgDQgUZwdogQMnrCTBa210eBRHE4eoq9RLnhFU58XPO8ifcSg4DLleJhqIFqCXb2nt-LXF9xU0-FFZTekVTjWvQPz2a4dpuDARg5QwZtM48K4cOtG4je9-iQmlfjx_jj91AhgUWB315USfC2U0exjMsxD37m3Qn8B_FCNeaDSWz_Cs_ixcggh6CRM3BxOtYdQUxxLccxsvwGDEWrvCyllsXmGHJq_4B0tyOqjxTZNQ_kWUxVao-Tv6cdRuDAxYJSWiEVplFLdOIiv8J9CYgTcy011ujj44DzmrtzXx2IBSpZ0sH2tS_xRqkVWWPZeqsZrGcBhnsmi6McAf7bsDHvAt-q2ca4h0I2rpZzTBpTcLS2jugFAmJMXQFVALMs8uyD4kU7ps6tMjv_dh5KyqNd2exDtEsSYaZZHRrHJKiA3s_1__Ma41BLEMUwimFlwASiVt4I2SrmdiODrZachyuZBtcUA25woJG6GhsyhfAIKxRMjl6cj2p_jo-vxW9m65ZT4VyNb6ddJ5dZ2CLjR0TpjiXL3mGkDDxBBV_za2N9DvRw3hdtFihvGUgNdYQ_YrwH0ZkEB43my71c3_pF0ePMmJ7NMGIC2lgtaZ-grDWNO87wDwLK3M-yQ' \
--data-raw '{"transition":"to_upcoming"}'
```

pokud je vše v pořádku, vrátí odpověď **204**. pokud přechod není možný, vrátí odpověď **422**.

## Opakování dražby

`PATCH https://www.portaldrazeb.cz/admin/auctions/999ex6789-20-5xq/copy.json`

slouží pro opakování/zkopírování dražby. opakovat lze pouze ukončené dražby.
do request body vložíme číslo listu kopie dražby (integer):
```json
{"auction":{"addon":123}}
```
pokud pošleme s prázdným request body, číslo se zvolí automaticky.

```sh
curl --location --request PATCH 'https://www.portaldrazeb.cz/admin/auctions/999ex4790-20-xjnwa/copy.json' \
--header 'Content-Type: application/json;charset=utf-8' \
--header 'Authorization: Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJSUzI1NiJ9.eyJpYXQiOjE1OTY3NTQ0MTYsImV4cCI6MTU5Njc1ODAxNiwicm9sZXMiOlsiUk9MRV9BVUNUSU9ORUVSX0VYRUNVVE9SIiwiUk9MRV9PRkZJQ0VfRVhURVJOQUwiXSwiZW1haWwiOiJleGVjdXRvci1leHRlcm4tdGVzdEB0ZXN0LmFyb2RheC5jb20ifQ.XZhq7yjjMZPe64eDhkgk5hh_yvFRBNtbPD0CceMC5vFwP08yaSxG1nbuZZzl3UnjABYmWkWlNYxmfPo-1Ap81ejq8ZxFfEj-4gaUr3E963Jbz57YYmahINHCNCzlo6mA7Nheb-7huPrDuD6v-8pznvgUH_n-z4yRozoqI__C0FFGeNqTgOMHxsK4SzW-Hs2gFdDbCqMO0lIjmh1_ccM05eDU4O0jjuUbIbRAdz5X7Gq38rpKvJ_B-lYC89HsBVe0thrnPmqMN9nQZsLAx8_MS4SlF1LIzBntbevwFJxayKrnCdzHHqmBImuJfAflwcKrZTP77I3WrkerPJ2lVX1DMId_w5NfNo9oTMcfjJG4e9Z_F8KcAR6bM_dFIvTdB5ys-EmhbZUXKWUlCi5BPJaoiBL75ODfa8bRPjypC68SWVt3uQ70GPavi6so9iFu6TYIFdkQka74wjvQggSE39ofTwvn_1ymY3198mLiJuYlomhOpvEQc_UvGYfxOL8CgltKNAv1Nd6zNMc-oCnf5rhP_CCBGJzigF-EAnXJAsZY6w9NdGsxaOd2hHXMWLG6LeAqFYNSKGWiqtm_VZTe4LGKh_k-xBDJQExI4SYeIwDKpxHYdmNNh8XVOznGVEYzSI4ZWF-PyD0Kisfos6_Gf38d44kBSMJo151z87et-QIavQE' \
--data-raw '{"auction":{"addon":123}}'
```

pokud je vše v pořádku, vrátí odpověď **204**. pokud přechod není kopie možná, vrátí odpověď **403**.

------
EOF